/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.options.controls;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.ArrayUtils;

public class KeyBindsList
extends ContainerObjectSelectionList<Entry> {
    private static final int ITEM_HEIGHT = 20;
    final KeyBindsScreen keyBindsScreen;
    private int maxNameWidth;

    public KeyBindsList(KeyBindsScreen p_345102_, Minecraft p_346132_) {
        super(p_346132_, p_345102_.width, p_345102_.layout.getContentHeight(), p_345102_.layout.getHeaderHeight(), 20);
        this.keyBindsScreen = p_345102_;
        Object[] $$2 = (KeyMapping[])ArrayUtils.clone((Object[])p_346132_.options.keyMappings);
        Arrays.sort($$2);
        String $$3 = null;
        for (Object $$4 : $$2) {
            MutableComponent $$6;
            int $$7;
            String $$5 = ((KeyMapping)$$4).getCategory();
            if (!$$5.equals($$3)) {
                $$3 = $$5;
                this.addEntry(new CategoryEntry(Component.translatable($$5)));
            }
            if (($$7 = p_346132_.font.width($$6 = Component.translatable(((KeyMapping)$$4).getName()))) > this.maxNameWidth) {
                this.maxNameWidth = $$7;
            }
            this.addEntry(new KeyEntry((KeyMapping)$$4, $$6));
        }
    }

    public void resetMappingAndUpdateButtons() {
        KeyMapping.resetMapping();
        this.refreshEntries();
    }

    public void refreshEntries() {
        this.children().forEach(Entry::refreshEntry);
    }

    @Override
    public int getRowWidth() {
        return 340;
    }

    public class CategoryEntry
    extends Entry {
        final Component name;
        private final int width;

        public CategoryEntry(Component p_345224_) {
            this.name = p_345224_;
            this.width = ((KeyBindsList)KeyBindsList.this).minecraft.font.width(this.name);
        }

        @Override
        public void render(GuiGraphics p_345402_, int p_345541_, int p_345306_, int p_346166_, int p_346154_, int p_345075_, int p_346184_, int p_346385_, boolean p_346139_, float p_345189_) {
            p_345402_.drawString(((KeyBindsList)KeyBindsList.this).minecraft.font, this.name, KeyBindsList.this.width / 2 - this.width / 2, p_345306_ + p_345075_ - ((KeyBindsList)KeyBindsList.this).minecraft.font.lineHeight - 1, -1, false);
        }

        @Override
        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent p_344970_) {
            return null;
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                @Override
                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                @Override
                public void updateNarration(NarrationElementOutput p_344973_) {
                    p_344973_.add(NarratedElementType.TITLE, CategoryEntry.this.name);
                }
            });
        }

        @Override
        protected void refreshEntry() {
        }
    }

    public class KeyEntry
    extends Entry {
        private static final Component RESET_BUTTON_TITLE = Component.translatable("controls.reset");
        private static final int PADDING = 10;
        private final KeyMapping key;
        private final Component name;
        private final Button changeButton;
        private final Button resetButton;
        private boolean hasCollision = false;

        KeyEntry(KeyMapping p_345998_, Component p_345196_) {
            this.key = p_345998_;
            this.name = p_345196_;
            this.changeButton = Button.builder(p_345196_, p_345593_ -> {
                KeyBindsList.this.keyBindsScreen.selectedKey = p_345998_;
                KeyBindsList.this.resetMappingAndUpdateButtons();
            }).bounds(0, 0, 75, 20).createNarration(p_346090_ -> {
                if (p_345998_.isUnbound()) {
                    return Component.translatable("narrator.controls.unbound", p_345196_);
                }
                return Component.translatable("narrator.controls.bound", p_345196_, p_346090_.get());
            }).build();
            this.resetButton = Button.builder(RESET_BUTTON_TITLE, p_346334_ -> {
                ((KeyBindsList)KeyBindsList.this).minecraft.options.setKey(p_345998_, p_345998_.getDefaultKey());
                KeyBindsList.this.resetMappingAndUpdateButtons();
            }).bounds(0, 0, 50, 20).createNarration(p_344899_ -> Component.translatable("narrator.controls.reset", p_345196_)).build();
            this.refreshEntry();
        }

        @Override
        public void render(GuiGraphics p_345065_, int p_345504_, int p_345678_, int p_344740_, int p_345885_, int p_344888_, int p_345213_, int p_344829_, boolean p_346415_, float p_345934_) {
            int $$10 = KeyBindsList.this.getScrollbarPosition() - this.resetButton.getWidth() - 10;
            int $$11 = p_345678_ - 2;
            this.resetButton.setPosition($$10, $$11);
            this.resetButton.render(p_345065_, p_345213_, p_344829_, p_345934_);
            int $$12 = $$10 - 5 - this.changeButton.getWidth();
            this.changeButton.setPosition($$12, $$11);
            this.changeButton.render(p_345065_, p_345213_, p_344829_, p_345934_);
            p_345065_.drawString(((KeyBindsList)KeyBindsList.this).minecraft.font, this.name, p_344740_, p_345678_ + p_344888_ / 2 - ((KeyBindsList)KeyBindsList.this).minecraft.font.lineHeight / 2, -1);
            if (this.hasCollision) {
                int $$13 = 3;
                int $$14 = this.changeButton.getX() - 6;
                p_345065_.fill($$14, p_345678_ - 1, $$14 + 3, p_345678_ + p_344888_, -65536);
            }
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.changeButton, (Object)this.resetButton);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.changeButton, (Object)this.resetButton);
        }

        @Override
        protected void refreshEntry() {
            this.changeButton.setMessage(this.key.getTranslatedKeyMessage());
            this.resetButton.active = !this.key.isDefault();
            this.hasCollision = false;
            MutableComponent $$0 = Component.empty();
            if (!this.key.isUnbound()) {
                for (KeyMapping $$1 : ((KeyBindsList)KeyBindsList.this).minecraft.options.keyMappings) {
                    if ($$1 == this.key || !this.key.same($$1)) continue;
                    if (this.hasCollision) {
                        $$0.append(", ");
                    }
                    this.hasCollision = true;
                    $$0.append(Component.translatable($$1.getName()));
                }
            }
            if (this.hasCollision) {
                this.changeButton.setMessage(Component.literal("[ ").append(this.changeButton.getMessage().copy().withStyle(ChatFormatting.WHITE)).append(" ]").withStyle(ChatFormatting.RED));
                this.changeButton.setTooltip(Tooltip.create(Component.translatable("controls.keybinds.duplicateKeybinds", $$0)));
            } else {
                this.changeButton.setTooltip(null);
            }
            if (KeyBindsList.this.keyBindsScreen.selectedKey == this.key) {
                this.changeButton.setMessage(Component.literal("> ").append(this.changeButton.getMessage().copy().withStyle(ChatFormatting.WHITE, ChatFormatting.UNDERLINE)).append(" <").withStyle(ChatFormatting.YELLOW));
            }
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        abstract void refreshEntry();
    }
}

